/* sccsid[] = "@(#) $Id: //bas/46C/src/proj/crfc/crfcsimp.cpp#2 $ SAP" */   
//
// SAP RFC Classes C++ library.
// Copyright (C) 1996 SAP America, Inc.
// All rights reserved. 

///////////////////////////////////////////////////////////////////////////////////////
//  File crfcsimp.cpp

#if defined(SAPonRS6000)
#pragma priority(50)
#endif

#include "crfcsimp.h"

extern CRfcTrace RfcClassTrace;

///////////////////////////////////////////////////////////////////////////////////////
//    CRfcSimpleParam definition                                

CRfcSimpleParam::CRfcSimpleParam(CSTR paramName, //Parameter name
                                 unsigned nType, //Parameter type (RFC data type) 
                                 int nLength,    //Parameter value length in bytes
                                 int nDecimals,  //number of decimal places in value
                                 BOOL bAutoCreate)  //  If auto created or not
								 :CRfcImpExpParam(paramName)
{
    
    assert(IsValidSAPType(nType));

	if (!IsValidSAPType(nType))
		return;

    m_nType = nType;

    // Set the flag m_bPassImportToR3 to FALSE so that by default this parameter
    //  will not be passed to ABAP function module when the RFC call is made.  The
    //  only way to pass this simple import parameter to the ABAP function module is
    //  to set the value of this parameter by the application program.
    // See Value() function of this class.
    m_bPassImportToR3 = FALSE;

    //if user used default attributes info, i.e., no attribute 
    //information is provided, then do nothing
    if( nLength == 0 && nType == TYPC )
        return;
    
	m_bAutoCreate = bAutoCreate;
    //For certain RFC types, need to calculate the length.
    //If user specified the length, make sure it matches the
    //calculated length.
    //Call the parent CRfcImpExpParam's SetLength method to
    //allocate appropriate buffer memory
    SetLength(CheckSAPTypeLength(nType, nLength));

    if(nType == TYPP)
	{
        assert(nDecimals <= 2*nLength-1);
		if (nDecimals > 2*nLength-1)
			return;
	}

    m_nDecimals = nDecimals;

    m_RfcData.SetAttributes( m_pDataBuffer, nType, nLength, nDecimals );
    //set the data to an initial value ( 0 for numerics, space for char's)
    m_RfcData.Init();
}

CRfcSimpleParam::CRfcSimpleParam (const CRfcSimpleParam& sourceParam)
:CRfcImpExpParam(sourceParam)
{
    m_nType = sourceParam.m_nType;
    m_nDecimals = sourceParam.m_nDecimals;
	m_bAutoCreate = sourceParam.m_bAutoCreate;

    //if source only has default attributes info, i.e., no attribute 
    //information is provided, then do nothing
    if( m_nLength == 0 && m_nType == TYPC )
        return;


    m_RfcData.SetAttributes( m_pDataBuffer, m_nType, m_nLength, m_nDecimals);
}



CRfcSimpleParam::~CRfcSimpleParam()
{
}


CRfcSimpleParam& CRfcSimpleParam::operator=(const CRfcSimpleParam& sourceParam)
{
    if( this == &sourceParam ) return *this;

    CRfcImpExpParam::operator=(sourceParam);
    m_nType = sourceParam.m_nType;
    m_nDecimals = sourceParam.m_nDecimals;
	m_bAutoCreate = sourceParam.m_bAutoCreate;

    //if source only has default attributes info, i.e., no attribute 
    //information is provided, then do nothing
    if( m_nLength == 0 && m_nType == TYPC )
        return *this;

    m_RfcData.SetAttributes( m_pDataBuffer, m_nType, m_nLength, m_nDecimals );

    return *this;
}


void CRfcSimpleParam::SetAttributes(unsigned nType,
                                    int nLength,
                                    int nDecimals)
{ 
    //Only allow setting of attributes on objects created via
    //default constructor
    assert(m_nLength==0 && m_nType==TYPC);

	if (!(m_nLength==0 && m_nType==TYPC))
		return;

    assert(IsValidSAPType(nType));

	if (!IsValidSAPType(nType))
		return;
    
    m_nType = nType;
    m_nDecimals = nDecimals;

    //For certain RFC types, need to calculate the length.
    //If user specified the length, make sure it matches the
    //calculated length.
    //Call the parent CRfcImpExpParam's SetLength method to
    //allocate appropriate buffer memory
    SetLength(CheckSAPTypeLength(nType, nLength));

    if(nType == TYPP)
	{
        assert(nDecimals <= 2*nLength-1);
		if (nDecimals > 2*nLength-1)
			return;
	}

    m_RfcData.SetAttributes( m_pDataBuffer, nType, nLength, nDecimals );
    //set the data to an initial value ( 0 for numerics, space for char's)
    m_RfcData.Init();
}

void CRfcSimpleParam::Clear()
{
    if( m_nLength == 0 )
        return;

    m_RfcData.Init();

}

void CRfcSimpleParam::FillParamStruct(RFC_PARAMETER *pParamStruct) const
{
    CRfcImpExpParam::FillParamStruct(pParamStruct);
    pParamStruct->type = m_nType;
}

void CRfcSimpleParam::ConvertData (void)
{
    m_RfcData.ConvertData();
}


#if defined(SAPonNT)

BOOL CRfcSimpleParam::Write(CRfcPersistStream& ps, CSTR dir)
{
    return ps.WriteSimpleParam(GetParamName(), dir, m_nType, m_nLength, m_nDecimals);
}

BOOL CRfcSimpleParam::Read(CRfcPersistStream& ps, CSTR funcname, CSTR dir, int nIndex)
{
BOOL result;

    result = ps.ReadSimpleParam(funcname, dir, nIndex, &m_rstrParamName, &m_nType, &m_nLength, &m_nDecimals);

    assert(IsValidSAPType(m_nType));

	if (!IsValidSAPType(m_nType))
		return FALSE;

    m_bPassImportToR3 = FALSE;

    if( m_nLength > 0 )
    {
        m_pDataBuffer =  (void*)(new BYTE[m_nLength]);
        if( m_pDataBuffer == NULL )
        {
            RfcClassTrace.TraceTime();
            RfcClassTrace.Trace(CRFCSIMP_READ);
            RfcClassTrace.Trace(CRFCIMEX_MEMORY_FAILURE);
            throw MEMORY;
        }
    }

    m_rstrParamName.SetCapitalize(TRUE);

    //if user used default attributes info, i.e., no attribute 
    //information is provided, then do nothing
    if( m_nLength == 0 && m_nType == TYPC )
        return result;
    
    assert(m_nDecimals <= 2*m_nLength-1);

	if (m_nDecimals > 2*m_nLength-1)
		return FALSE;

    m_RfcData.SetAttributes( m_pDataBuffer, m_nType, m_nLength, m_nDecimals );
    //set the data to an initial value ( 0 for numerics, space for char's)
    m_RfcData.Init();

    return result;
}

#endif // #if defined(SAPonNT)

